/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWParticipant;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VWParticipantCache {
    private Hashtable participantCache = new Hashtable(50);
    private static int MAX_CACHE_SIZE = 2500;
    private static final long serialVersionUID = 464L;

    private String formKey(String domainName, String userName) {
        return domainName + "/" + userName;
    }

    private synchronized VWParticipant get(String domainName, String userName) {
        String key = this.formKey(domainName, userName);
        VWParticipantWrapper w = (VWParticipantWrapper)this.participantCache.get(key);
        if (w != null) {
            return w.getUser();
        }
        return null;
    }

    public synchronized void put(String domainName, String userName, VWParticipant participant) {
        String key = this.formKey(domainName, userName);
        this.participantCache.put(key, new VWParticipantWrapper(participant));
        this.cleanup();
    }

    private void cleanup() {
        int size = this.participantCache.size();
        block0: for (int i = 5; size > MAX_CACHE_SIZE && i >= 0; --i) {
            Enumeration e = this.participantCache.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                VWParticipantWrapper w = (VWParticipantWrapper)this.participantCache.get(key);
                long TTL = i * 3600 * 1000;
                if (w == null || !w.expired(i < 5, TTL)) continue;
                this.participantCache.remove(key);
                if (--size >= MAX_CACHE_SIZE) continue;
                continue block0;
            }
        }
    }

    public void checkNames(String domainName, String[] theUserNameList, VWParticipant[] arr, Vector listToFetch) {
        int arrSize;
        int nItems;
        int n = nItems = theUserNameList == null ? 0 : theUserNameList.length;
        if (nItems == 0) {
            return;
        }
        int n2 = arrSize = arr == null ? 0 : arr.length;
        if (arrSize != nItems) {
            return;
        }
        for (int i = 0; i < nItems; ++i) {
            VWParticipant res = this.get(domainName, theUserNameList[i]);
            if (res != null) {
                arr[i] = res;
                continue;
            }
            arr[i] = null;
            listToFetch.add(theUserNameList[i]);
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   05 Oct 2006 15:18:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    class VWParticipantWrapper {
        private VWParticipant m_user = null;
        private long enqueueTime;
        private long lastAccessed;

        protected VWParticipantWrapper(VWParticipant user) {
            this.m_user = user;
            this.enqueueTime = System.currentTimeMillis();
            this.lastAccessed = System.currentTimeMillis();
        }

        protected VWParticipant getUser() {
            this.lastAccessed = System.currentTimeMillis();
            return this.m_user;
        }

        protected boolean expired(boolean force, long TTL) {
            boolean res;
            long now = System.currentTimeMillis();
            boolean bl = res = now - this.lastAccessed > TTL;
            if (!res && force) {
                res = now - this.enqueueTime > TTL;
            }
            return res;
        }
    }
}

